#include <solomon/libs/cpp/actors/metrics/threadpool_metrics_collector.h>
#include <solomon/libs/cpp/actors/metrics/threadpool_metrics.h>

#include <solomon/libs/cpp/actors/test_runtime/actor_runtime.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;
using namespace NMonitoring;
using namespace NActors;

class TThreadPoolMetricsCollectorTest: public ::testing::Test {
protected:
    void SetUp() override {
        ActorRuntime_ = TTestActorRuntime::CreateInited(1, true, false);
        for (int idx = 0; idx < 10; idx++) {
            MetricsByThreadPool_.emplace_back(Registry_, ToString(idx));
        }

        auto collector = CreateThreadPoolMetricCollector(TDuration::MilliSeconds(100), MetricsByThreadPool_);
        ActorId_ = ActorRuntime_->Register(collector.release());
        ActorRuntime_->WaitForBootstrap();
        EdgeId_ = ActorRuntime_->AllocateEdgeActor();
    }

    void TearDown() override {
        ActorRuntime_.Reset();
    }

    void Wakeup() const {
        auto ev = std::make_unique<TEvents::TEvWakeup>();
        ActorRuntime_->Send(ActorId_, THolder(ev.release()));
    }

    void SendPoison() const {
        auto ev = std::make_unique<TEvents::TEvPoison>();
        ActorRuntime_->Send(ActorId_, EdgeId_, THolder(ev.release()));
    }

    ui64 GetTotalReceiveEvents() const {
        ui64 total = 0;
        for (auto &metrics: MetricsByThreadPool_) {
           total += metrics.ReceivedEvents->Get();
        }
        return total;
    }

    template <typename TEvent>
    typename TEvent::TPtr ReceiveResponse() {
        return ActorRuntime_->GrabEdgeEvent<TEvent>(EdgeId_, TDuration::Seconds(10));
    }

protected:
    THolder<TTestActorRuntime> ActorRuntime_;
    std::vector<TTreadPoolMetrics> MetricsByThreadPool_;
    TActorId ActorId_;
    TActorId EdgeId_;
    TMetricRegistry Registry_;
};

TEST_F(TThreadPoolMetricsCollectorTest, ReceiveEvents) {
    auto prev = GetTotalReceiveEvents();
    Wakeup();
    SendPoison();
    ReceiveResponse<TEvents::TEvPoisonTaken>();

    auto actual = GetTotalReceiveEvents();
    ASSERT_GT(actual, prev);
}
