#pragma once

#include <solomon/libs/cpp/actors/fwd.h>

#include <library/cpp/threading/future/fwd.h>

#include <util/datetime/base.h>

#include <set>

namespace NSolomon {

/**
 * Starts poisoning given actors and returns future to be able to subscribe on
 * this operation result.
 *
 * @param actorSystem   actor system where actors were created
 * @param toPoison      the set of actors to be poisoned
 * @param timeout       optional timeout, zero means no timeout
 * @return future result
 */
NThreading::TFuture<void> AsyncPoison(
        NActors::TActorSystem* actorSystem,
        std::set<NActors::TActorId> toPoison,
        TDuration timeout = {});

} // namespace NSolomon
