#pragma once

#include <solomon/libs/cpp/actors/fwd.h>

#include <library/cpp/actors/core/events.h>

#include <util/datetime/base.h>

#include <set>

namespace NSolomon {

/**
 * Creates an actor which is responsible to poison other actors.
 *
 * Actor will start poisoning of the given actors only after receiving TEvPoison event,
 * after all actors will be poisoned it will send back TEvPoisonTaken event.
 *
 * @param toPoison   the set of actors to be poisoned
 * @param timeout    optional timeout, zero means no timeout
 * @return new actor instance
 */
std::unique_ptr<NActors::IActor> CreatePoisoner(std::set<NActors::TActorId> toPoison, TDuration timeout = {});

/**
 * Creates poisoner and forwards given poison event to it.
 *
 * This function implicitly gets reference to TActorContext, so it must be called inside actor's context.
 * Be aware that you have to use the original TEvPoison event, because a poisoner will respond with
 * TEvPoisonTaken to its sender.
 *
 * @param event     poison event
 * @param toPoison  actors to poison
 * @param timeout   optional timeout, zero means no timeout
 */
void PoisonAll(
        const NActors::TEvents::TEvPoison::TPtr& event,
        std::set<NActors::TActorId> toPoison,
        TDuration timeout = {});

} // namespace NSolomon
