#pragma once

#include <solomon/libs/cpp/actors/config/actor_system_config.pb.h>

#include <library/cpp/actors/core/actorsystem.h>
#include <library/cpp/logger/backend.h>
#include <library/cpp/threading/future/fwd.h>
#include <library/cpp/monlib/metrics/metric_registry.h>

#include <util/generic/ptr.h>

namespace NInterconnect {
    class TPollerThreads;
} // namespace NInterconnect

namespace NMonitoring {
    struct TDynamicCounters;
} // namespace NMonitoring

namespace NSolomon {
    class TActorRuntime {
    public:
        using TPtr = THolder<TActorRuntime>;
        ~TActorRuntime();

        void Start();
        void Stop();

        NActors::TActorId Register(
            NActors::IActor* actor,
            NActors::TMailboxType::EType mailboxType = NActors::TMailboxType::HTSwap,
            ui32 executorPool = 0,
            ui64 revolvingCounter = 0,
            const NActors::TActorId& parentId = NActors::TActorId()
        );

        NActors::TActorId Register(
                std::unique_ptr<NActors::IActor> actor,
                NActors::TMailboxType::EType mailboxType = NActors::TMailboxType::HTSwap,
                ui32 executorPool = 0,
                ui64 revolvingCounter = 0,
                const NActors::TActorId& parentId = NActors::TActorId())
        {
            return Register(actor.release(), mailboxType, executorPool, revolvingCounter, parentId);
        }

        void RegisterLocalService(const NActors::TActorId& serviceId, const NActors::TActorId& actorId);

        NThreading::TFuture<void> AsyncPoison(NActors::TActorId actorId);

        NThreading::TFuture<void> AsyncPoison(std::set<NActors::TActorId> toPoison, TDuration timeout = {});

        NActors::TActorSystem& ActorSystem() {
            Y_VERIFY(ActorSystem_);
            return *ActorSystem_;
        }

        const NActors::TActorSystem& ActorSystem() const {
            Y_VERIFY(ActorSystem_);
            return *ActorSystem_;
        }

        static TActorRuntime::TPtr Create(
            const TActorSystemConfig& config,
            const std::shared_ptr<NMonitoring::TMetricRegistry>& metrics,
            void* appData = nullptr);

        ui32 NodeId() const {
            return ActorSystem_->NodeId;
        }

        ui32 FindExecutorByName(const TString& name) const;
        void AddExecutorPool(TString name, ui32 id);
        TStringBuf ExecutorName(ui32 id);
        ui32 ExecutorsSize();

        void ReopenLog();
        void EmergencyLog(TStringBuf msg);

    private:
        void InitInterconnect(
            NActors::TActorSystemSetup& setup,
            const TActorSystemConfig& config,
            std::shared_ptr<NMonitoring::TMetricRegistry> metrics
        );

    private:
        THolder<NActors::TActorSystem> ActorSystem_;
        THashMap<TString, ui32> ExecutorPools_;
        THashMap<ui32, TStringBuf> ExecutorPoolsReverseIdx_;
        TLogBackend* Logger_;
    };
} // NSolomon
