#pragma once

#include <solomon/libs/cpp/logging/logging.h>

#ifndef NDEBUG
# include <util/system/type_name.h>
#endif

/**
 * Very simple header-only library to intercept and log events in actor state functions.
 *
 * This header replaces macroses from library/cpp/actors/core/hfunc.h
 * Every event that is handled with sFunc or hFunc is logged to TraceEvents component.
 * There's no (simple) way to customize which events are traced and which are not.
 *
 * This code is probably safe to use in production, but it requires to violate the
 * style guide and is a BIG HACK. So please, restrict its usage for debugging purposes only.
 *
 * To enable TRACE messages only for TraceEvents use the following logger configuration
 * LogConfig {
 *     ...
 *     Entry {
 *         Component: "TraceEvents"
 *         Level: TRACE
 *     }
 * }
 *
 * Now you can simply add
 *
 * #include <solomon/libs/cpp/actors/trace/trace_actor_events.h>
 *
 * after library/cpp/actors/core headers.
 */

namespace NTraceActorEvents {

    inline TString ActorType(NActors::IActor* self) {
#ifdef NDEBUG
        Y_UNUSED(self);
        return "";
#else
        TString className = TypeName(*self);

        TStringBuf actorName = className;
        auto angle = actorName.find('<');
        if (angle != TStringBuf::npos) {
            actorName = actorName.SubString(0, angle);
        }
        auto colon = actorName.rfind(':');
        if (colon != TStringBuf::npos) {
            actorName = actorName.SubString(colon + 1, actorName.size() - colon - 1);
        }
        return TString(actorName);
#endif
    }

    inline void TraceActorEvent(
            NActors::IActor* self,
            NActors::IEventHandle* ev,
            const char* evTypeStr,
            const char* stateFunc)
    {
        LOG_TRACE_S(::NActors::TActorContext::AsActorContext(), ::NSolomon::ELogComponent::TraceEvents,
                self->SelfId() << ' ' << ActorType(self) << ':' << stateFunc << " received " << evTypeStr <<
                " from " << ev->Sender << " cookie " << ev->Cookie);
    }

}

#ifdef STATEFN
# undef STATEFN
#endif

#define STATEFN(funcName)                                                                   \
    void funcName(TAutoPtr<::NActors::IEventHandle>& ev, const ::NActors::TActorContext&) { \
        funcName ## __Real(ev, Y_STRINGIZE(funcName));                                      \
    }                                                                                       \
    void funcName ## __Real(TAutoPtr<::NActors::IEventHandle>& ev, const char* stateFunc)

#ifdef hFunc
# undef hFunc
#endif

#define hFunc(TEvType, HandleFunc)                                                  \
    case TEvType::EventType: {                                                      \
        NTraceActorEvents::TraceActorEvent(this, ev.Get(),                          \
                Y_STRINGIZE(TEvType), stateFunc);                                   \
        typename TEvType::TPtr* x = reinterpret_cast<typename TEvType::TPtr*>(&ev); \
        HandleFunc(*x);                                                             \
        break;                                                                      \
    }

#ifdef sFunc
# undef sFunc
#endif

#define sFunc(TEvType, HandleFunc)                                                  \
    case TEvType::EventType:                                                        \
        NTraceActorEvents::TraceActorEvent(this, ev.Get(),                          \
                Y_STRINGIZE(TEvType), stateFunc);                                   \
        HandleFunc();                                                               \
        break;
