#pragma once

#include <solomon/libs/cpp/auth/core/authenticator.h>

#include <library/cpp/actors/core/actor.h>

namespace NSolomon::NAuth {

class TAuthEvents: private TEventSlot<EEventSpace::Libs, ELibSlot::Auth> {
    enum {
        AuthenticationRequest = SpaceBegin,
        AuthenticationResponse,
        End,
    };

    static_assert(End < SpaceEnd, "too many event types");

public:
    struct TAuthenticationRequest: public NActors::TEventLocal<TAuthenticationRequest, TAuthEvents::AuthenticationRequest> {
        /// Headers of incoming http request
        ::NHttp::THeaders Headers;
        /// Acceptable types of authentication
        std::unordered_set<EAuthType> AuthTypes;

        explicit TAuthenticationRequest(TStringBuf httpHeaders)
            : Headers(httpHeaders)
        {
        }
    };

    struct TAuthenticationResponse: public NActors::TEventLocal<TAuthenticationResponse, TAuthEvents::AuthenticationResponse> {
        std::variant<TAuthSubject, TTokenParseError, TAuthError> AuthResult;

        explicit TAuthenticationResponse(TAuthSubject&& authSubject)
            : AuthResult(std::move(authSubject))
        {
        }

        explicit TAuthenticationResponse(TTokenParseError&& err)
            : AuthResult(err)
        {
        }

        explicit TAuthenticationResponse(TAuthError&& err)
            : AuthResult(err)
        {
        }

        bool Success() const {
            return std::holds_alternative<TAuthSubject>(AuthResult);
        }

        const TAuthSubject& GetAuthSubject() const {
            return std::get<TAuthSubject>(AuthResult);
        }

        bool TokenParseFail() const {
            return std::holds_alternative<TTokenParseError>(AuthResult);
        }

        bool AuthenticationFail() const {
            return std::holds_alternative<TAuthError>(AuthResult);
        }
    };
};

std::unique_ptr<NActors::IActor> CreateAuthenticationActor(std::shared_ptr<IAuthenticator> authenticator);

}
