#pragma once

#include "expire_lru_cache.h"

#include <solomon/libs/cpp/auth/core/authenticator.h>

#include <library/cpp/cache/cache.h>

#include <util/datetime/base.h>

template<>
struct THash<NSolomon::NAuth::TAuthToken> {
    size_t operator()(const NSolomon::NAuth::TAuthToken& token) const {
        return MultiHash(THash<ui8>{}(static_cast<ui8>(token.Type)), THash<TString>{}(token.Value));
    }
};

namespace NSolomon::NAuth {

struct TAuthenticationCacheParams {
    TDuration PositiveCacheTTL = {};
    size_t PositiveCacheSize = {};
    TDuration NegativeCacheTTL = {};
    size_t NegativeCacheSize = {};

     static TAuthenticationCacheParams Default();
};

class TAuthenticationCache {
public:
    TAuthenticationCache(TAuthenticationCacheParams params = TAuthenticationCacheParams::Default());

    std::optional<TAuthResult> Get(const TAuthToken& token, TInstant now);
    void Put(TAuthToken token, TAuthResult authResult, TInstant now);
    void EvictExpired(TInstant now);

    TDuration GetMaxTTL() const {
        return Max(PositiveCache_.GetTTL(), NegativeCache_.GetTTL());
    }

private:
    TExpireLruCache<TAuthToken, TAuthSubject> PositiveCache_;
    TExpireLruCache<TAuthToken, TAuthError> NegativeCache_;
};

} // namespace NSolomon::NAuth
