#pragma once

#include "auth_subjects.h"

#include <solomon/protos/auth/internal_access.pb.h>

namespace NSolomon::NAuth {

/**
 * Simple authorizer with white and black lists. Just says if client is allowed without knowledge about roles.
 */
class IInternalAuthorizer {
public:
    virtual ~IInternalAuthorizer() = default;
    virtual bool IsAllowed(const TAuthSubject& authSubject) const = 0;
};

using IInternalAuthorizerPtr = std::shared_ptr<IInternalAuthorizer>;

IInternalAuthorizerPtr CreateInternalAuthorizer(const TInternalAccess& accessList);

} // namespace NSolomon::NAuth
