#pragma once

#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/error_or/error_or.h>

#include <solomon/protos/auth/tvm_config.pb.h>

#include <library/cpp/monlib/metrics/fwd.h>
#include <library/cpp/tvmauth/type.h>
#include <library/cpp/tvmauth/checked_service_ticket.h>
#include <library/cpp/tvmauth/checked_user_ticket.h>

namespace NSolomon::NAuth::NTvm {
    class ITvmClient: public TThrRefBase {
    public:
        virtual TString GetServiceTicketFor(const NTvmAuth::TTvmId dst) const = 0;

        virtual NTvmAuth::TCheckedServiceTicket CheckServiceTicket(TStringBuf ticket) const = 0;

        virtual NTvmAuth::TCheckedUserTicket CheckUserTicket(TStringBuf ticket, TMaybe<NTvmAuth::EBlackboxEnv> overrideEnv) const = 0;
    };

    using ITvmClientPtr = TIntrusivePtr<ITvmClient>;

    /**
     * thread safe
     */
    struct ITicketProvider: public TThrRefBase {
        using TTicketOrError = TErrorOr<TString, TGenericError>;

        virtual TTicketOrError GetTicket(ui32 clientId) const noexcept = 0;

        virtual void AddDestinationId(ui32 destId) noexcept = 0;
        virtual void AddDestinationIds(TVector<ui32> destIds) noexcept = 0;
    };

    using ITicketProviderPtr = TIntrusivePtr<ITicketProvider>;

    struct TTicketProviderConfig {
        NActors::TActorSystem& ActorSystem;
        ui32 ExecutorPool;

        TTvmConfig Config;
        NMonitoring::TMetricRegistry& Registry;
    };

    /**
     * not thread safe factory
     */
    class ITvmServicesFactory: public TThrRefBase {
    public:
        virtual ITvmClientPtr CreateTvmClient() = 0;
        virtual ITicketProviderPtr CreateTicketProvider() = 0;

        static TIntrusivePtr<ITvmServicesFactory> Create(TTicketProviderConfig config);
    };
} // namespace NSolomon::NAuth::NTvm
