#include <solomon/libs/cpp/backoff/backoff.h>
#include <solomon/libs/cpp/backoff/jitter.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;

TEST(TBackoffTest, LinearNoJitter) {
    TLinearBackoff<TNoJitter> backoff{TDuration::Seconds(5), TDuration::Seconds(60)};

    ASSERT_EQ(backoff.Min(), TDuration::Seconds(5));
    ASSERT_EQ(backoff.Max(), TDuration::Seconds(60));

    ASSERT_EQ(backoff(), TDuration::Seconds(5));
    ASSERT_EQ(backoff(), TDuration::Seconds(10));
    ASSERT_EQ(backoff(), TDuration::Seconds(15));
    ASSERT_EQ(backoff(), TDuration::Seconds(20));
    ASSERT_EQ(backoff(), TDuration::Seconds(25));
    ASSERT_EQ(backoff(), TDuration::Seconds(30));
    ASSERT_EQ(backoff(), TDuration::Seconds(35));
    ASSERT_EQ(backoff(), TDuration::Seconds(40));
    ASSERT_EQ(backoff(), TDuration::Seconds(45));
    ASSERT_EQ(backoff(), TDuration::Seconds(50));
    ASSERT_EQ(backoff(), TDuration::Seconds(55));
    ASSERT_EQ(backoff(), TDuration::Seconds(60));
    ASSERT_EQ(backoff(), TDuration::Seconds(60));
}

TEST(TBackoffTest, ExponentialNoJitter) {
    TExpBackoff<TNoJitter> backoff{TDuration::MilliSeconds(50), TDuration::Seconds(60)};

    ASSERT_EQ(backoff.Min(), TDuration::MilliSeconds(50));
    ASSERT_EQ(backoff.Max(), TDuration::Seconds(60));

    ASSERT_EQ(backoff(), TDuration::MilliSeconds(50));
    ASSERT_EQ(backoff(), TDuration::MilliSeconds(100));
    ASSERT_EQ(backoff(), TDuration::MilliSeconds(200));
    ASSERT_EQ(backoff(), TDuration::MilliSeconds(400));
    ASSERT_EQ(backoff(), TDuration::MilliSeconds(800));
    ASSERT_EQ(backoff(), TDuration::MilliSeconds(1'600));
    ASSERT_EQ(backoff(), TDuration::MilliSeconds(3'200));
    ASSERT_EQ(backoff(), TDuration::MilliSeconds(6'400));
    ASSERT_EQ(backoff(), TDuration::MilliSeconds(12'800));
    ASSERT_EQ(backoff(), TDuration::MilliSeconds(25'600));
    ASSERT_EQ(backoff(), TDuration::MilliSeconds(51'200));
    ASSERT_EQ(backoff(), TDuration::Seconds(60));
    ASSERT_EQ(backoff(), TDuration::Seconds(60));
}

TEST(TBackoffTest, ExponentialHalfJitter) {
    TExpBackoff<THalfJitter> backoff{
        TDuration::MilliSeconds(50),
        TDuration::Seconds(30),
        2305843009213693951};

    ASSERT_EQ(backoff(), TDuration::MicroSeconds(40519));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(99597));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(101617));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(254336));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(607679));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(1189438));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(2846534));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(5853273));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(7681610));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(24751774));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(23057551));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(19223009));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(24944752));
}

TEST(TBackoffTest, ExponentialFullJitter) {
    TExpBackoff<TFullJitter> backoff{
        TDuration::MilliSeconds(50),
        TDuration::Seconds(30),
        2305843009213693951};

    ASSERT_EQ(backoff(), TDuration::MicroSeconds(40519));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(49597));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(101617));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(54336));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(607679));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(389438));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(1246534));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(2653273));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(7681610));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(24751774));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(23057551));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(19223009));
    ASSERT_EQ(backoff(), TDuration::MicroSeconds(9944752));
}
