#include <solomon/libs/cpp/backoff/jitter.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;

TEST(TJitterTest, No) {
    TNoJitter jitter;

    ASSERT_EQ(jitter(TDuration::Zero()), TDuration::Zero());
    ASSERT_EQ(jitter(TDuration::MicroSeconds(6)), TDuration::MicroSeconds(6));
    ASSERT_EQ(jitter(TDuration::MicroSeconds(28)), TDuration::MicroSeconds(28));
    ASSERT_EQ(jitter(TDuration::MicroSeconds(496)), TDuration::MicroSeconds(496));
    ASSERT_EQ(jitter(TDuration::MicroSeconds(8128)), TDuration::MicroSeconds(8128));
    ASSERT_EQ(jitter(TDuration::MicroSeconds(33550336)), TDuration::MicroSeconds(33550336));
    ASSERT_EQ(jitter(TDuration::MicroSeconds(8589869056)), TDuration::MicroSeconds(8589869056));
}

TEST(TJitterTest, Half) {
    THalfJitter jitter{2147483647};

    ASSERT_EQ(jitter(TDuration::MicroSeconds(6)), TDuration::MicroSeconds(3));
    ASSERT_EQ(jitter(TDuration::MicroSeconds(28)), TDuration::MicroSeconds(14));
    ASSERT_EQ(jitter(TDuration::MicroSeconds(496)), TDuration::MicroSeconds(333));
    ASSERT_EQ(jitter(TDuration::MicroSeconds(8128)), TDuration::MicroSeconds(7016));
    ASSERT_EQ(jitter(TDuration::MicroSeconds(33550336)), TDuration::MicroSeconds(30587957));
    ASSERT_EQ(jitter(TDuration::MicroSeconds(589869056)), TDuration::MicroSeconds(568361083));
}

TEST(TJitterTest, Full) {
    TFullJitter jitter{2147483647};

    ASSERT_EQ(jitter(TDuration::MicroSeconds(6)), TDuration::MicroSeconds(3));
    ASSERT_EQ(jitter(TDuration::MicroSeconds(28)), TDuration::Zero());
    ASSERT_EQ(jitter(TDuration::MicroSeconds(496)), TDuration::MicroSeconds(333));
    ASSERT_EQ(jitter(TDuration::MicroSeconds(8128)), TDuration::MicroSeconds(2952));
    ASSERT_EQ(jitter(TDuration::MicroSeconds(33550336)), TDuration::MicroSeconds(30587957));
    ASSERT_EQ(jitter(TDuration::MicroSeconds(589869056)), TDuration::MicroSeconds(568361083));
}
