#pragma once

#include <util/stream/output.h>

namespace NSolomon {

class IBacktracePrinter {
public:
    virtual ~IBacktracePrinter() = default;

    /**
     * Will print human readable symbol name for a given frame.
     * Please note that this function will automatically add '\n' after symbol.
     *
     * @param frame   pointer to a frame
     * @param out     output stream
     */
    virtual void Print(void* frame, IOutputStream* out) = 0;
};

IBacktracePrinter* BacktracePrinter();

} // namespace NSolomon
