#include <library/cpp/testing/gtest/gtest.h>

#include <solomon/libs/cpp/backtrace/printer.h>

#include <util/system/backtrace.h>

// smoke tests to compare LLVM vs dladdr()

TEST(TBacktracePrinterTest, Llvm) {
    auto* printer = NSolomon::BacktracePrinter();

    void* array[300];
    const size_t s = BackTrace(array, Y_ARRAY_SIZE(array));

    for (size_t i = 0; i < s; i++) {
        Cerr << '#' << i << ' ';
        printer->Print(array[i], &Cerr);
    }
}

TEST(TBacktracePrinterTest, Dladdr) {
    void* array[300];
    const size_t s = BackTrace(array, Y_ARRAY_SIZE(array));

    char buf[1000];
    for (size_t i = 0; i < s; i++) {
        auto rs = ResolveSymbol(array[i], buf, std::size(buf));
        Cerr << '#' << i << ' ' << rs.Name << Endl;
    }
}
