#pragma once

#include <solomon/libs/cpp/grpc/client/client.h>
#include <solomon/libs/cpp/grpc/client/error.h>
#include <solomon/protos/common/url_info.pb.h>
#include <solomon/protos/configs/rpc/rpc_config.pb.h>

#include <library/cpp/grpc/client/grpc_client_low.h>
#include <library/cpp/monlib/encode/format.h>
#include <library/cpp/monlib/metrics/fwd.h>
#include <library/cpp/monlib/metrics/labels.h>
#include <library/cpp/threading/future/future.h>

namespace NSolomon::NCoremon {
    struct TProcessResult {
        ui32 SuccessMetricCount;
        yandex::solomon::common::UrlStatusType Status;
        TString Error;
    };

    struct TShardAssignments {
        using THost = std::pair<TString, ui32>;

        TString Leader;
        THashMap<THost, TVector<ui32>> Assignments;
    };

    struct TShardCreated {
        TString Leader;
        TString AssignedToHost;
        TString ShardId;
        ui32 NumId{0};
    };

    using TAsyncShardAssignments = NThreading::TFuture<TErrorOr<TShardAssignments, NSolomon::TApiCallError>>;
    using TAsyncDataProcessResponse = NThreading::TFuture<TErrorOr<TProcessResult, NSolomon::TApiCallError>>;
    using TAsyncVoid = NThreading::TFuture<TErrorOr<void, NSolomon::TApiCallError>>;
    using TAsyncShardCreated = NThreading::TFuture<TErrorOr<TShardCreated, NSolomon::TApiCallError>>;

    class ICoremonClient {
    public:
        virtual ~ICoremonClient() = default;

        virtual TAsyncDataProcessResponse ProcessPulledData(
            ui32 numId, TString host,
            const NMonitoring::TLabels& optLabels, NMonitoring::EFormat metricFormat,
            TInstant instant, TString response,
            TInstant prevInstant, TString prevResponse) noexcept = 0;

        virtual TAsyncShardAssignments GetShardAssignments() noexcept = 0;

        virtual TAsyncDataProcessResponse ProcessPushedData(
            ui32 numId,
            NMonitoring::EFormat format,
            TInstant ts,
            TString content) noexcept = 0;

        virtual TAsyncShardCreated CreateShard(
                TString projectId,
                TString serviceName,
                TString clusterName,
                TString createdBy) noexcept = 0;

        /// Stop the client. This call blocks until all requests are done if wait is set to true
        virtual void Stop(bool wait) = 0;
    };

    using ICoremonClientPtr = std::unique_ptr<ICoremonClient>;
    using ICoremonClusterClient = IClusterRpc<ICoremonClient>;
    using ICoremonClusterClientPtr = std::shared_ptr<ICoremonClusterClient>;

    ICoremonClientPtr CreateGrpcClient(
        const yandex::solomon::config::rpc::TGrpcClientConfig& conf, NMonitoring::TMetricRegistry& registry, TString clientId = {});

    ICoremonClusterClientPtr CreateGrpcClusterClient(
        const yandex::solomon::config::rpc::TGrpcClientConfig& conf, NMonitoring::TMetricRegistry& registry, TString clientId = {});
} // namespace NSolomon::NCoremon
