#pragma once

#include <solomon/libs/cpp/cluster_map/cluster.h>
#include <solomon/libs/cpp/grpc/client/client.h>
#include <solomon/libs/cpp/grpc/client/error.h>
#include <solomon/libs/cpp/clients/slicer/api_types.h>
#include <solomon/protos/common/url_info.pb.h>
#include <solomon/protos/configs/rpc/rpc_config.pb.h>
#include <solomon/services/ingestor/api/ingestor_grpc_service.grpc.pb.h>

#include <library/cpp/grpc/client/grpc_client_low.h>
#include <library/cpp/monlib/encode/format.h>
#include <library/cpp/monlib/metrics/fwd.h>
#include <library/cpp/monlib/metrics/labels.h>
#include <library/cpp/threading/future/future.h>

namespace NSolomon::NIngestor {

struct TShardCreated {
    TString Leader;
    TString AssignedToHost;
    TString ShardId;
    ui32 NumId{0};
};

struct TShardAssignments {
    using THost = std::pair<TString, ui32>;

    TString Leader;
    THashMap<THost, TVector<ui32>> Assignments;
};

using TAsyncDataProcessResponse = NThreading::TFuture<TErrorOr<yandex::monitoring::ingestor::TDataProcessResponse, NSolomon::TApiCallError>>;
using TAsyncShardCreated = NThreading::TFuture<TErrorOr<TShardCreated, NSolomon::TApiCallError>>;
using TGetAssignedShardsResponseOrError = TErrorOr<yandex::monitoring::ingestor::TGetAssignedShardsResponse, NGrpc::TGrpcStatus>;
using TGetAssignedShardsResponseOrErrorPtr = std::unique_ptr<TGetAssignedShardsResponseOrError>;
using TAsyncGetAssignedShardsResponse = NThreading::TFuture<TGetAssignedShardsResponseOrErrorPtr>;
using TAsyncShardAssignments = NThreading::TFuture<TErrorOr<TShardAssignments, NSolomon::TApiCallError>>;

class IIngestorClient {
public:
    virtual ~IIngestorClient() = default;

    virtual TAsyncDataProcessResponse ProcessPulledData(const yandex::monitoring::ingestor::TPulledDataRequest& request) noexcept = 0;

    virtual TAsyncDataProcessResponse ProcessPushedData(const yandex::monitoring::ingestor::TPushedDataRequest& request) noexcept = 0;

    virtual TAsyncGetAssignedShardsResponse GetAssignedShards(const yandex::monitoring::ingestor::TGetAssignedShardsRequest& request) noexcept = 0;

    virtual TAsyncShardCreated CreateShard(const yandex::monitoring::ingestor::TCreateShardRequest& request) noexcept = 0;

    /// Stop the client. This call blocks until all requests are done if wait is set to true
    virtual void Stop(bool wait) = 0;
};

using IIngestorClientPtr = std::unique_ptr<IIngestorClient>;
using IIngestorClusterClientPtr = std::shared_ptr<IClusterRpc<IIngestorClient>>;

IIngestorClientPtr CreateIngestorGrpcClient(
        const yandex::solomon::config::rpc::TGrpcClientConfig& conf,
        NMonitoring::TMetricRegistry& registry,
        TString clientId = {});

IIngestorClusterClientPtr CreateIngestorGrpcClusterClient(
        const yandex::solomon::config::rpc::TGrpcClientConfig& conf,
        NMonitoring::TMetricRegistry& registry,
        TString clientId = {});

} // namespace NSolomon::NIngestor
