#pragma once

#include <solomon/libs/cpp/grpc/client/async_response.h>
#include <solomon/libs/cpp/grpc/client/client.h>
#include <solomon/protos/configs/rpc/rpc_config.pb.h>

#include <ydb/core/protos/grpc.pb.h>

#include <library/cpp/monlib/metrics/fwd.h>

namespace NSolomon::NKikimr {

using TKikimrAsyncResponse = TAsyncResponse<NKikimrClient::TResponse>;

/**
 * Interface of single node Kikimr RPC.
 */
class IKikimrRpc {
public:
    virtual ~IKikimrRpc() = default;

    virtual TKikimrAsyncResponse SchemeDescribe(const NKikimrClient::TSchemeDescribe& req) = 0;

    virtual TKikimrAsyncResponse SchemeOperation(const NKikimrClient::TSchemeOperation& req) = 0;

    virtual TKikimrAsyncResponse SchemeOperationStatus(const NKikimrClient::TSchemeOperationStatus& req) = 0;

    virtual TKikimrAsyncResponse HiveCreateTablet(const NKikimrClient::THiveCreateTablet& req) = 0;

    virtual TKikimrAsyncResponse TabletStateRequest(const NKikimrClient::TTabletStateRequest& req) = 0;

    virtual TKikimrAsyncResponse LocalEnumerateTablets(const NKikimrClient::TLocalEnumerateTablets& req) = 0;

    virtual TKikimrAsyncResponse KeyValue(const NKikimrClient::TKeyValueRequest& req) = 0;

    /**
     * Stop the RPC. This call blocks until all requests are completed if wait is set to true.
     */
    virtual void Stop(bool wait) = 0;
};

using IKikimrClusterRpc = IClusterRpc<IKikimrRpc>;

std::unique_ptr<IKikimrRpc> CreateNodeGrpc(
        const yandex::solomon::config::rpc::TGrpcClientConfig& conf,
        NMonitoring::IMetricRegistry& registry,
        TString clientId = {});

std::shared_ptr<IKikimrClusterRpc> CreateClusterGrpc(
        const yandex::solomon::config::rpc::TGrpcClientConfig& conf,
        NMonitoring::IMetricRegistry& registry,
        TString clientId = {});

} // namespace NSolomon::NKikimr
