#include "load_service_client.h"

#include <utility>

namespace NSolomon::NLoadInfo {
namespace {

using namespace NGrpc;
using namespace NMonitoring;
using namespace NThreading;
using namespace yandex::monitoring::load_info;

using yandex::solomon::config::rpc::TGrpcClientConfig;

class TGrpcLoadInfoClientBase: public ILoadInfoClient {
public:
    TGrpcLoadInfoClientBase(
            IMetricRegistry&,
            std::unique_ptr<TGrpcServiceConnection<LoadInfoService>> connection)
        : Connection_{std::move(connection)}
    {
    }

    TAsyncLoadInfoResponse GetLoadInfo(TString address) noexcept override {
        LoadInfoRequest req;
        req.Setaddress(address);

        auto promise = NewPromise<TErrorOr<LoadInfoResponse, TApiCallError>>();

        auto cb = [promise] (TGrpcStatus&& status, LoadInfoResponse&& result) mutable {
            if (!status.Ok()) {
                promise.SetValue(FromGrpcError<LoadInfoResponse>(status));
            } else {
                promise.SetValue(result);
            }
        };

        Connection_->Request<LoadInfoRequest, LoadInfoResponse>(
                req,
                std::move(cb),
                &LoadInfoService::Stub::AsyncGetLoadInfo);

        return promise.GetFuture();
    }

    void Stop(bool) noexcept override {
    }

private:
    std::unique_ptr<TGrpcServiceConnection<LoadInfoService>> Connection_;
};

ILoadInfoClientPtr CreateLoadInfoClient(
        IMetricRegistry& registry,
        std::unique_ptr<TGrpcServiceConnection<LoadInfoService>> connection)
{
    return std::make_unique<TGrpcLoadInfoClientBase>(registry, std::move(connection));
}

} // namespace

ILoadInfoClientPtr CreateLoadInfoGrpcClient(
        const yandex::solomon::config::rpc::TGrpcClientConfig& conf,
        NMonitoring::TMetricRegistry& registry,
        TString clientId)
{
    auto threadPool = CreateGrpcThreadPool(conf);
    auto sc = CreateGrpcServiceConnection<LoadInfoService>(
        conf,
        false,
        registry,
        std::move(threadPool),
        std::move(clientId));

    return CreateLoadInfoClient(registry, std::move(sc));
}

ILoadInfoClusterClientPtr CreateLoadInfoGrpcClusterClient(
        const yandex::solomon::config::rpc::TGrpcClientConfig& conf,
        NMonitoring::TMetricRegistry& registry,
        TString clientId)
{
    return std::make_shared<TGrpcClusterClientBase<LoadInfoService, ILoadInfoClient>>(
        conf,
        false,
        registry,
        CreateLoadInfoClient,
        std::move(clientId));
}

} // namespace NSolomon::NLoadInfo
