#pragma once

#include <solomon/libs/cpp/grpc/client/client.h>
#include <solomon/libs/cpp/grpc/client/error.h>
#include <solomon/libs/cpp/load_info_service/proto/load_info_grpc_service.grpc.pb.h>

#include <solomon/protos/configs/rpc/rpc_config.pb.h>

#include <library/cpp/monlib/metrics/metric_registry.h>
#include <library/cpp/threading/future/future.h>

namespace NSolomon::NLoadInfo {

using TAsyncLoadInfoResponse = NThreading::TFuture<TErrorOr<
        yandex::monitoring::load_info::LoadInfoResponse,
        NSolomon::TApiCallError>>;

class ILoadInfoClient {
public:
    virtual ~ILoadInfoClient() = default;

    virtual TAsyncLoadInfoResponse GetLoadInfo(TString address) noexcept = 0;

    /// Stop the client. This call blocks until all requests are done if wait is set to true
    virtual void Stop(bool wait) = 0;
};

using ILoadInfoClientPtr = std::unique_ptr<ILoadInfoClient>;
using ILoadInfoClusterClientPtr = std::shared_ptr<IClusterRpc<ILoadInfoClient>>;

ILoadInfoClientPtr CreateLoadInfoGrpcClient(
        const yandex::solomon::config::rpc::TGrpcClientConfig& conf,
        NMonitoring::TMetricRegistry& registry,
        TString clientId = {});

ILoadInfoClusterClientPtr CreateLoadInfoGrpcClusterClient(
        const yandex::solomon::config::rpc::TGrpcClientConfig& conf,
        NMonitoring::TMetricRegistry& registry,
        TString clientId = {});

} // namespace NSolomon::NLoadInfo
