#pragma once

#include <solomon/libs/cpp/grpc/client/async_response.h>
#include <solomon/libs/cpp/grpc/client/client.h>
#include <solomon/protos/configs/rpc/rpc_config.pb.h>
#include <solomon/services/memstore/api/memstore_service.pb.h>

#include <library/cpp/monlib/metrics/fwd.h>

namespace NSolomon::NMemStore {

using TWriteAsyncResponse = TAsyncResponse<yandex::monitoring::memstore::WriteResponse>;
using TListShardsAsyncResponse = TAsyncResponse<yandex::monitoring::memstore::ListShardsResponse>;
using TFindAsyncResponse = TAsyncResponse<yandex::monitoring::memstore::FindResponse>;
using TLabelKeysAsyncResponse = TAsyncResponse<yandex::monitoring::memstore::LabelKeysResponse>;
using TLabelValuesAsyncResponse = TAsyncResponse<yandex::monitoring::memstore::LabelValuesResponse>;
using TUniqueLabelsAsyncResponse = TAsyncResponse<yandex::monitoring::memstore::UniqueLabelsResponse>;
using TReadOneAsyncResponse = TAsyncResponse<yandex::monitoring::memstore::ReadOneResponse>;
using TReadManyAsyncResponse = TAsyncResponse<yandex::monitoring::memstore::ReadManyResponse>;

/**
 * Interface of single node MemStore RPC.
 */
class IMemStoreRpc {
public:
    virtual ~IMemStoreRpc() {}

    virtual TWriteAsyncResponse Write(const yandex::monitoring::memstore::WriteRequest& request) = 0;

    virtual TListShardsAsyncResponse ListShards(const yandex::monitoring::memstore::ListShardsRequest& request) = 0;

    virtual TFindAsyncResponse Find(const yandex::monitoring::memstore::FindRequest& request) = 0;

    virtual TLabelKeysAsyncResponse LabelKeys(const yandex::monitoring::memstore::LabelKeysRequest& request) = 0;

    virtual TLabelValuesAsyncResponse LabelValues(const yandex::monitoring::memstore::LabelValuesRequest& request) = 0;

    virtual TUniqueLabelsAsyncResponse UniqueLabels(const yandex::monitoring::memstore::UniqueLabelsRequest& request) = 0;

    virtual TReadOneAsyncResponse ReadOne(const yandex::monitoring::memstore::ReadOneRequest& request) = 0;

    virtual TReadManyAsyncResponse ReadMany(const yandex::monitoring::memstore::ReadManyRequest& request) = 0;

    /**
     * Stop the client. This call blocks until all requests are completed if wait is set to true
     */
    virtual void Stop(bool wait) = 0;
};

/**
 * Interface of cluster aware MemStore RPC.
 */
using IMemStoreClusterRpc = IClusterRpc<IMemStoreRpc>;

std::unique_ptr<IMemStoreRpc> CreateNodeGrpc(
    const yandex::solomon::config::rpc::TGrpcClientConfig& conf,
    NMonitoring::IMetricRegistry& registry,
    TString clientId = {});

std::shared_ptr<IClusterRpc<IMemStoreRpc>> CreateClusterGrpc(
    const yandex::solomon::config::rpc::TGrpcClientConfig& conf,
    NMonitoring::IMetricRegistry& registry,
    TString clientId = {});

} // namespace NSolomon::NMemStore
