#include "api_types.h"

namespace NSolomon::NSlicer::NApi {
namespace {

template <typename TStream>
void Out(TStream& os, const NSolomon::NSlicer::NApi::TSlice& slice) {
    os << '[' << slice.Start << "; " << slice.End << ']';
}

template <typename TStream>
void Out(TStream& os, const NSolomon::NSlicer::NApi::TSlices& slices) {
    os << '[';

    size_t idx = 0;
    for (auto slice: slices) {
        if (idx > 0) {
            os << ", ";
        }

        os << slice;
        ++idx;
    }

    os << ']';
}

template <typename TStream>
void Out(TStream& os, const NSolomon::NSlicer::NApi::THosts& hosts) {
    os << '[';

    size_t i = 0;
    for (const auto& host: hosts) {
        if (i++ > 0) {
            os << ", ";
        }

        os << '"' << host << '"';
    }

    os << ']';
}

} // namespace

IOutputStream& operator<<(IOutputStream& os, const NSolomon::NSlicer::NApi::TSlice& slice) {
    Out(os, slice);
    return os;
}

std::ostream& operator<<(std::ostream& os, const NSolomon::NSlicer::NApi::TSlice& slice) {
    Out(os, slice);
    return os;
}

IOutputStream& operator<<(IOutputStream& os, const NSolomon::NSlicer::NApi::TSlices& slices) {
    Out(os, slices);
    return os;
}

std::ostream& operator<<(std::ostream& os, const NSolomon::NSlicer::NApi::TSlices& slices) {
    Out(os, slices);
    return os;
}

IOutputStream& operator<<(IOutputStream& os, const NSolomon::NSlicer::NApi::THosts& hosts) {
    Out(os, hosts);
    return os;
}

std::ostream& operator<<(std::ostream& os, const NSolomon::NSlicer::NApi::THosts& hosts) {
    Out(os, hosts);
    return os;
}

} // namespace NSolomon::NSlicer::NApi
