#pragma once

#include <solomon/services/slicer/lib/events/event_slots.h>

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/clients/slicer/api_types.h>
#include <solomon/libs/cpp/clients/slicer/slicer_client.h>

#include <solomon/protos/slicer/slicelet_config.pb.h>

#include <library/cpp/actors/core/actor.h>
#include <library/cpp/actors/core/event_local.h>

namespace NSolomon::NSlicerClient {

// TODO(ivanzhukov): use the Libs event space
struct TSliceletListenerEvents: private TEventSlot<EEventSpace::Slicer, NSlicer::ES_SLICELET_LISTENER> {
    enum {
        SlicesUpdate = SpaceBegin,
        Subscribe,
        Unsubscribe,
        End,
    };

    static_assert(End < SpaceEnd, "too many event types");

    struct TSlicesUpdate: NActors::TEventLocal<TSlicesUpdate, SlicesUpdate> {
        yandex::monitoring::slicer::GetSlicesByHostResponse Update;

        explicit TSlicesUpdate(decltype(Update) update)
            : Update{std::move(update)}
        {}
    };

    struct TEvSubscribe: NActors::TEventLocal<TEvSubscribe, Subscribe> {
    };

    struct TEvUnsubscribe: NActors::TEventLocal<TEvUnsubscribe, Unsubscribe> {
    };
};

struct TSliceletListenerOptions {
    TString Service{};
    TString Host{};
    TDuration UpdateInterval{};
    TDuration RetriesBackoff{};
    ui32 MaxRetries{};
    ISlicerClusterClientPtr SlicerClients{};
};

NSlicerClient::TSliceletListenerOptions ConstructSliceletListenerOptions(
    yandex::solomon::config::slicer::SliceletConfig config,
    NMonitoring::TMetricRegistry& registry,
    const TString& localAddress);

/**
 * Creates a SliceletListener actor.
 *
 * This actor gets updates, i.e. (un)assigned slices, from a Slicer server
 * and reports them back as an event
 */
NActors::IActor* CreateSliceletListenerActor(TSliceletListenerOptions opts);

/**
 * Actor for testing purposes. Just sends given slices back
 *
 */
NActors::IActor* CreateSliceletListenerActorForTesting(NSlicer::NApi::TSlices slices);

} // namespace NSolomon::NSlicerClient
