#pragma once

#include "api_types.h"

#include <solomon/services/slicer/api/slicer_service.pb.h>

#include <solomon/libs/cpp/error_or/error_or.h>
#include <solomon/libs/cpp/grpc/client/client.h>
#include <solomon/protos/configs/rpc/rpc_config.pb.h>

#include <library/cpp/grpc/client/grpc_client_low.h>
#include <library/cpp/monlib/metrics/metric_registry.h>
#include <library/cpp/threading/future/future.h>

#include <util/generic/ptr.h>

namespace NSolomon::NSlicerClient {

using TGetAllAssignmentsResponseOrError =
        TErrorOr<yandex::monitoring::slicer::GetAllAssignmentsResponse, ::NGrpc::TGrpcStatus>;
using TGetAllAssignmentsResponseOrErrorPtr = std::unique_ptr<TGetAllAssignmentsResponseOrError>;
using TAsyncGetAllAssignmentsResponse = NThreading::TFuture<TGetAllAssignmentsResponseOrErrorPtr>;

using TGetSlicesByHostResponseOrError =
        TErrorOr<yandex::monitoring::slicer::GetSlicesByHostResponse, ::NGrpc::TGrpcStatus>;
using TGetSlicesByHostResponseOrErrorPtr = std::unique_ptr<TGetSlicesByHostResponseOrError>;
using TAsyncGetSlicesByHostResponse = NThreading::TFuture<TGetSlicesByHostResponseOrErrorPtr>;

class ISlicerClient {
public:
    virtual ~ISlicerClient() = default;

    [[nodiscard]]
    virtual TAsyncGetAllAssignmentsResponse GetAllAssignments(TString service) noexcept = 0;
    [[nodiscard]]
    virtual TAsyncGetSlicesByHostResponse GetSlicesByHost(TString service, TString nodeFqdn) noexcept = 0;

    /// Stop the client. This call blocks until all requests are completed if wait is set to true
    virtual void Stop(bool wait) = 0;
};

using ISlicerClientPtr = std::unique_ptr<ISlicerClient>;
using ISlicerClusterClient = IClusterRpc<ISlicerClient>;
using ISlicerClusterClientPtr = std::shared_ptr<ISlicerClusterClient>;

std::unique_ptr<ISlicerClient> CreateSlicerGrpcClient(
        const yandex::solomon::config::rpc::TGrpcClientConfig& conf,
        NMonitoring::TMetricRegistry& registry,
        TString clientId = {});

ISlicerClusterClientPtr CreateSlicerGrpcClusterClient(
        const yandex::solomon::config::rpc::TGrpcClientConfig& conf,
        NMonitoring::TMetricRegistry& registry,
        TString clientId = {});

} // namespace NSolomon::NSlicerClient
