#pragma once

#include <solomon/libs/cpp/error_or/error_or.h>
#include <solomon/libs/cpp/http/client/curl/client.h>
#include <solomon/libs/cpp/http/client/http.h>
#include <solomon/libs/cpp/http/client/request_error.h>
#include <solomon/protos/configs/rpc/rpc_config.pb.h>

#include <library/cpp/threading/future/future.h>

// I have absolutely no idea why tsdb api is defined in history_api
#include <infra/yasm/interfaces/internal/history_api.pb.h>

#include <library/cpp/threading/future/fwd.h>
#include <library/cpp/monlib/metrics/fwd.h>

namespace NSolomon::NTsdb {

struct TFetchHostsResponse {
    TVector<TString> Hosts;
};

template <typename T>
using TAsyncResponse = NThreading::TFuture<TErrorOr<T, ::NSolomon::TRequestError>>;
using TReadAggregatedAsyncResponse = TAsyncResponse<::NYasm::NInterfaces::NInternal::THistoryReadAggregatedResponse>;
using TFetchHostsResponseAsyncResponse = TAsyncResponse<TFetchHostsResponse>;
using TCircuitBreakerConfig = yandex::solomon::config::rpc::TCircuitBreakerConfig;

/**
 * Interface of single node Tsdb RPC.
 */
class ITsdbRpc {
public:
    virtual ~ITsdbRpc() = default;

    virtual TReadAggregatedAsyncResponse ReadAggregated(const ::NYasm::NInterfaces::NInternal::THistoryReadAggregatedRequest& request) = 0;
    virtual TFetchHostsResponseAsyncResponse FetchHosts(TStringBuf group) = 0;

    /**
     * Stop the client. This call blocks until all requests are completed if wait is set to true
     */
    virtual void Stop(bool wait) = 0;
};

struct TTsdbClientConfig {
    TCurlClientOptions CurlClientOptions;
    TRequestOpts RequestOptions;
};

class ITsdbClusterRpc {
public:
    virtual ~ITsdbClusterRpc() = default;

    virtual void Stop(bool wait) = 0;
    virtual void Add(TStringBuf host) = 0;
    virtual ITsdbRpc* Get(TStringBuf host) noexcept = 0;
};

std::unique_ptr<ITsdbRpc> CreateNodeHttp(
        TString address,
        IHttpClientPtr httpClient,
        TString clientId,
        TRequestOpts requestOpts,
        NMonitoring::TMetricRegistry& registry,
        const std::optional<TCircuitBreakerConfig>& circuitBreakerConfig = std::nullopt);

std::shared_ptr<ITsdbClusterRpc> CreateTsdbClusterRpc(
        ui32 port,
        TString clientId,
        TTsdbClientConfig config,
        NMonitoring::TMetricRegistry& registry,
        TCircuitBreakerConfig circuitBreakerConfig);

} // namespace NSolomon::NTsdb
