#pragma once

#include "rpc.h"

#include <util/generic/hash.h>

namespace NSolomon::NTsdb {

/**
 * Stub implementation of Tsdb RPC.
 */
class TTsdbRpcStub: public ITsdbRpc {
public:
    TReadAggregatedAsyncResponse ReadAggregated(const NYasm::NInterfaces::NInternal::THistoryReadAggregatedRequest&) override {
        return NotImplemented<TReadAggregatedAsyncResponse>("ReadAggregated");
    }

    TFetchHostsResponseAsyncResponse FetchHosts(TStringBuf) override {
        return NotImplemented<TFetchHostsResponseAsyncResponse>("FetchHosts");
    }

    void Stop(bool /*wait*/) override {
        // nop
    }

protected:
    template <typename T>
    static T NotImplemented(TStringBuf method) {
        return NThreading::MakeErrorFuture<NThreading::TFutureType<T>>(
            std::make_exception_ptr(yexception() << "TsdbRpc::" << method << "() is not implemented"));
    }
};


class TTsdbClusterRpcStub: public ITsdbClusterRpc {
public:
    explicit TTsdbClusterRpcStub(THashMap<TString, std::shared_ptr<ITsdbRpc>> nodeRpc)
        : NodeRpc_{std::move(nodeRpc)}
    {
        Addresses_.reserve(NodeRpc_.size());
        for (const auto& [k, v]: NodeRpc_) {
            Addresses_.emplace_back(k);
        }
    }

    ITsdbRpc* Get(TStringBuf address) noexcept override {
        auto it = NodeRpc_.find(address);
        return it == NodeRpc_.end() ? nullptr : it->second.get();
    }

    void Add(TStringBuf) override {
        ythrow yexception() << "not implemented";
    }

    void Stop(bool /*wait*/) override {
        // nop
    }

private:
    THashMap<TString, std::shared_ptr<ITsdbRpc>> NodeRpc_;
    std::vector<TString> Addresses_;
};

} // namespace NSolomon::NTsdb
