#pragma once

#include <solomon/libs/cpp/cloud/access_service/iam_account_type_enum.h>
#include <solomon/libs/cpp/error_or/error_or.h>
#include <solomon/libs/cpp/grpc/client/error.h>
#include <solomon/protos/configs/rpc/rpc_config.pb.h>

#include <yandex/cloud/priv/servicecontrol/v1/access_service.grpc.pb.h>

#include <library/cpp/monlib/metrics/metric_registry.h>
#include <library/cpp/threading/future/future.h>

#include <util/generic/ptr.h>

namespace NSolomon {

enum class EAccessServiceAuthErrorType {
    InternalRetriable = 0,
    InternalNonRetriable,
    FailedAuth,
};

struct TAuthError {
    EAccessServiceAuthErrorType Type;
    TString Message;

    TAuthError(EAccessServiceAuthErrorType type, TString msg)
        : Type{type}
        , Message{std::move(msg)}
    {}
};

struct TIamAccount {
    EIamAccountType Type;
    /**
     * Empty for an anonymous account
     */
    TString Id;
    /**
     * Different depending on an account type.
     *   User: federation id
     *   Service: folder id
     *   Anonymous: empty
     */
    TString ScopeId;
};

using TAsyncAuthenticateResponse = NThreading::TFuture<TErrorOr<TIamAccount, TAuthError>>;
using TAsyncAuthorizeResponse = NThreading::TFuture<
        TErrorOr<yandex::cloud::priv::servicecontrol::v1::AuthorizeResponse, ::NGrpc::TGrpcStatus>>;

class IAccessServiceClient: public TThrRefBase {
public:
    virtual TAsyncAuthenticateResponse Authenticate(TString iamToken) noexcept = 0;
    virtual TAsyncAuthorizeResponse Authorize(const yandex::cloud::priv::servicecontrol::v1::AuthorizeRequest& req) noexcept = 0;

    /// Stop the client. This call blocks until all requests are done if wait is set to true
    virtual void Stop(bool wait) = 0;
};

using IAccessServiceClientPtr = TIntrusivePtr<IAccessServiceClient>;

IAccessServiceClientPtr CreateAccessServiceGrpcClient(
        const yandex::solomon::config::rpc::TGrpcClientConfig& conf,
        NMonitoring::TMetricRegistry& registry,
        TString clientId = {});

} // namespace NSolomon

template <>
void Out<NSolomon::TIamAccount>(IOutputStream& Out, const NSolomon::TIamAccount& acc);
