#pragma once

#include <solomon/libs/cpp/error_or/error_or.h>

#include <cloud/bitbucket/private-api/third_party/envoy/api/envoy/config/endpoint/v3/endpoint.pb.h>

namespace NSolomon::NCloud::NEnvoy {

struct TEndpoint {
    TString Hostname;
    TString Address;
};

/**
 * Retrieves endpoints from the given cluster load assignment info.
 * This function will took some strings from the message, so it will be invalid after this function call.
 *
 * @param cluster  envoy cluster load assignment
 * @return vector of present endpoints or an error
 */
TErrorOr<std::vector<TEndpoint>, TGenericError> GetEndpoints(envoy::config::endpoint::v3::ClusterLoadAssignment* cluster);

/**
 * Tries to parse endpoints from the generic envoy resource.
 * Currently only ClusterLoadAssignment is supported, see
 * https://www.envoyproxy.io/docs/envoy/latest/api-v3/config/endpoint/v3/endpoint.proto#config-endpoint-v3-clusterloadassignment
 * for more information.
 *
 * @param resource  envoy resource
 * @return
 */
TErrorOr<std::vector<TEndpoint>, TGenericError> ParseClusterLoadAssignment(const google::protobuf::Any& resource);

} // namespace NSolomon::NCloud::NEnvoy
