#pragma once

#include <solomon/libs/cpp/grpc/client/async_response.h>
#include <solomon/libs/cpp/grpc/client/client.h>
#include <solomon/protos/configs/rpc/rpc_config.pb.h>

#include <library/cpp/monlib/metrics/fwd.h>

#include <cloud/bitbucket/private-api/third_party/envoy/api/envoy/service/endpoint/v3/eds.pb.h>

namespace NSolomon::NCloud::NEnvoy {

using TDescoveryAsyncResponse = TAsyncResponse<envoy::service::discovery::v3::DiscoveryResponse>;

class IEndpointRpc {
public:
    virtual ~IEndpointRpc() {}

    virtual TDescoveryAsyncResponse FetchEndpoints(const envoy::service::discovery::v3::DiscoveryRequest& req) = 0;
};

using IEndpointRpcPtr = std::unique_ptr<IEndpointRpc>;
using IEndpointClusterRpcPtr = std::shared_ptr<IClusterRpc<IEndpointRpc>>;

IEndpointRpcPtr CreateEndpointGrpc(
        const yandex::solomon::config::rpc::TGrpcClientConfig& conf,
        NMonitoring::IMetricRegistry& registry,
        TString clientId = {});

IEndpointClusterRpcPtr CreateEndpointClusterGrpc(
        const yandex::solomon::config::rpc::TGrpcClientConfig& conf,
        NMonitoring::IMetricRegistry& registry,
        TString clientId = {});

} // namespace NSolomon::NCloud::NEnvoy
