#include <solomon/libs/cpp/cloud/envoy/cluster_load_assignment.h>

#include <library/cpp/testing/gtest/gtest.h>
#include <library/cpp/resource/resource.h>

#include <google/protobuf/text_format.h>

using namespace NSolomon::NCloud;
using namespace google::protobuf;

TEST(TClusterLoadAssignemnt, GetEndpoints) {
    auto pbText = NResource::Find("/test_cluster_assignment.txt");

    envoy::config::endpoint::v3::ClusterLoadAssignment cluster;
    ASSERT_TRUE(TextFormat::ParseFromString(pbText, &cluster));

    auto endpoints = NEnvoy::GetEndpoints(&cluster);
    ASSERT_TRUE(endpoints.Success()) << endpoints.Error().Message();
    ASSERT_EQ(endpoints.Value().size(), 6u);

    auto it = endpoints.Value().begin();

    ASSERT_EQ(it->Hostname, "ig.cloud.yandex.net.");
    ASSERT_EQ(it->Address, "2a02:6b8:c02:900:0:f803:0:128");
    ++it;

    ASSERT_EQ(it->Hostname, "ig.cloud.yandex.net.");
    ASSERT_EQ(it->Address, "2a02:6b8:c0e:500:0:f803:0:39a");
    ++it;

    ASSERT_EQ(it->Hostname, "ig.cloud.yandex.net.");
    ASSERT_EQ(it->Address, "2a02:6b8:c03:500:0:f803:0:166");
    ++it;

    ASSERT_EQ(it->Hostname, "ig.cloud.yandex.net.");
    ASSERT_EQ(it->Address, "2a02:6b8:c02:900:0:f803:0:1f2");
    ++it;

    ASSERT_EQ(it->Hostname, "ig.cloud.yandex.net.");
    ASSERT_EQ(it->Address, "2a02:6b8:c0e:500:0:f803:0:135");
    ++it;

    ASSERT_EQ(it->Hostname, "ig.cloud.yandex.net.");
    ASSERT_EQ(it->Address, "2a02:6b8:c03:500:0:f803:0:19d");
    ++it;

    ASSERT_EQ(it, endpoints.Value().end());
}

TEST(TClusterLoadAssignemnt, ParseClusterLoadAssignment) {
    auto pbText = NResource::Find("/test_cluster_assignment.txt");

    envoy::config::endpoint::v3::ClusterLoadAssignment cluster;
    ASSERT_TRUE(TextFormat::ParseFromString(pbText, &cluster));

    Any resource;
    ASSERT_TRUE(resource.PackFrom(cluster));

    auto endpoints = NEnvoy::ParseClusterLoadAssignment(resource);
    ASSERT_TRUE(endpoints.Success()) << endpoints.Error().Message();
    ASSERT_EQ(endpoints.Value().size(), 6u);
}

TEST(TClusterLoadAssignemnt, ParseClusterLoadAssignment_Arena) {
    auto pbText = NResource::Find("/test_cluster_assignment.txt");
    Arena arena;

    auto* cluster = Arena::CreateMessage<envoy::config::endpoint::v3::ClusterLoadAssignment>(&arena);
    ASSERT_TRUE(TextFormat::ParseFromString(pbText, cluster));

    auto* resource = Arena::CreateMessage<Any>(&arena);
    ASSERT_TRUE(resource->PackFrom(*cluster));

    auto endpoints = NEnvoy::ParseClusterLoadAssignment(*resource);
    ASSERT_TRUE(endpoints.Success()) << endpoints.Error().Message();
    ASSERT_EQ(endpoints.Value().size(), 6u);
}
