#include <solomon/libs/cpp/cloud/iam/iam.h>
#include <solomon/libs/cpp/cloud/iam/client.h>

#include <library/cpp/getopt/last_getopt.h>
#include <library/cpp/monlib/metrics/metric_registry.h>

using namespace NSolomon::NCloud;
using namespace yandex::solomon::config::rpc;
using namespace NLastGetopt;


int main(int argc, const char** argv) {
    TString privKey, pubKey, keyId, accId;
    NMonitoring::TMetricRegistry registry;

    TOpts opts = NLastGetopt::TOpts::Default();
    opts.AddHelpOption();
    opts.AddLongOption("priv").RequiredArgument("FILE").StoreResult(&privKey).Required();
    opts.AddLongOption("pub").RequiredArgument("FILE").StoreResult(&pubKey).Required();
    opts.AddLongOption('k', "key-id").RequiredArgument("ID").StoreResult(&keyId).Required();
    opts.AddLongOption('a', "acc-id").RequiredArgument("ID").StoreResult(&accId).Required();
    opts.SetFreeArgsNum(0);

    TOptsParseResult res(&opts, argc, argv);

    TGrpcClientConfig grpcConf;
    grpcConf.AddAddresses("iam.api.cloud.yandex.net");
    auto client = CreateGrpcIamClient(grpcConf, registry);
    TTokenProviderConf conf {
        .ServiceAccountId = accId,
        .KeyId = keyId,
        .PublicKeyFile = pubKey,
        .PrivateKeyFile = privKey,
    };

    struct TLogger: ILogger {
        void Write(ELogPriority, TString msg) override {
            Cerr << msg << Endl;
        }
    };

    auto logger = MakeIntrusive<TLogger>();

    auto tokenProvider = CreateTokenProvider(std::move(conf), client, logger);
    tokenProvider->Start(EStartPolicy::Sync);
    auto token = tokenProvider->Token();
    Cout << "Got token with expiration time at "
        << token->ExpiresAt() << ":\n"
        << token->Token() << Endl;
}
