#pragma once

#include "iam.h"

#include <solomon/protos/configs/rpc/rpc_config.pb.h>

#include <library/cpp/monlib/metrics/fwd.h>
#include <library/cpp/threading/future/future.h>

namespace NSolomon::NCloud {
    class IIamClient: public TThrRefBase {
    public:
        virtual ~IIamClient() = default;
        virtual NThreading::TFuture<ITokenPtr> CreateIamToken(TString jwt) = 0;
    };

    using IIamClientPtr = TIntrusivePtr<IIamClient>;

    IIamClientPtr CreateGrpcIamClient(const yandex::solomon::config::rpc::TGrpcClientConfig& grpcConf, NMonitoring::IMetricRegistry& registry, TString clientId = {});
} // namespace NSolomon::NCloud
