#include "counters.h"

#include <library/cpp/monlib/metrics/metric_registry.h>

namespace NSolomon::NCloud {
    TDefaultCounters::TDefaultCounters(NMonitoring::TMetricRegistry& r)
        : Fail_{r.Counter({{"sensor", "iam.tokenUpdate.fail"}})}
        , Success_{r.Counter({{"sensor", "iam.tokenUpdate.success"}})}
        , TokenAge_{r.IntGauge({{"sensor", "iam.tokenAgeSeconds"}})}
        , TokenRemaining_{r.IntGauge({{"sensor", "iam.tokenRemainingSeconds"}})}
    {
    }

    void TDefaultCounters::Fail() {
        Fail_->Inc();
    }

    void TDefaultCounters::Success() {
        Success_->Inc();
    }

    void TDefaultCounters::SetTokenAge(TDuration age) {
        TokenAge_->Set(age.Seconds());
    }

    void TDefaultCounters::SetRemainingLifetime(TDuration age) {
        TokenRemaining_->Set(age.Seconds());
    }
} // namespace NSolomon::NCloud
