#pragma once

#include <solomon/libs/cpp/cloud/iam/iam.h>
#include <solomon/libs/cpp/error_or/error_or.h>

#include <solomon/protos/configs/rpc/rpc_config.pb.h>

#include <library/cpp/ipv6_address/ipv6_address.h>
#include <library/cpp/monlib/metrics/fwd.h>
#include <library/cpp/threading/future/future.h>

namespace NSolomon::NCloud {
    struct TInstanceGroup {
        struct TInstance {
            TInstance(TString internalFqdn, TIpv6Address publicAddr)
                : Fqdn{std::move(internalFqdn)}
                , Address{std::move(publicAddr)}
            {
            }

            TString Fqdn;
            TIpv6Address Address;
        };

        TVector<TInstance> Instances;
    };

    using TListInstancesResult = TErrorOr<TInstanceGroup, TGenericError>;
    using TListInstanceGroupsResult = TErrorOr<TVector<TString>, TGenericError>;

    struct IInstanceGroupClient: TThrRefBase {
        virtual NThreading::TFuture<TListInstancesResult> ListInstances(TString id) = 0;
        virtual NThreading::TFuture<TListInstanceGroupsResult> ListInstanceGroups(TString folderId) = 0;
        virtual NThreading::TFuture<TListInstancesResult> ListInstancesForFolder(TString folderId) = 0;
    };

    using IInstanceGroupClientPtr = TIntrusivePtr<IInstanceGroupClient>;

    IInstanceGroupClientPtr CreateInstanceGroupClient(
        const yandex::solomon::config::rpc::TGrpcClientConfig& config,
        ITokenProviderPtr tokenProvider,
        NMonitoring::TMetricRegistry& registry,
        TString clientId = {}
    );
} // namespace NSolomon::NCloud
