#pragma once

#include <solomon/libs/cpp/cluster_map/cluster.h>
#include <solomon/libs/cpp/cluster_membership/config/cluster_membership_config.pb.h>
#include <solomon/libs/cpp/cluster_membership/grpc_client.h>
#include <solomon/libs/cpp/grpc/server/service.h>

#include <solomon/protos/configs/rpc/rpc_config.pb.h>

namespace NSolomon::NClusterMembership {

enum class EMembershipMode {
    /**
     * In this mode, the node doesn't request any other node by its own will. The only thing it does is
     * forwarding pings from a requester to a target node (e.g. probing its neighbors). So basically it acts just like
     * a proxy
     */
    Passive,
    /**
     * In this mode, the node actively probes all its neighbors
     */
    Active,
};

THolder<NActors::IActor> CreateClusterMembershipActor(
        TString clusterName,
        yandex::monitoring::cluster_membership::ClusterMembershipConfig clusterMembershipConfig,
        ui16 port,
        NMonitoring::TMetricRegistry& registry,
        IClusterMapPtr cluster = {},
        TString clientId = {},
        EMembershipMode mode = EMembershipMode::Active);

} // namespace NSolomon::NClusterMembership
