#pragma once

#include "common.h"

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/cluster_map/cluster.h>
#include <solomon/libs/cpp/error_or/error_or.h>

#include <library/cpp/actors/core/event_local.h>

namespace NSolomon::NClusterMembership {

enum EClusterMembershipEventsSlots {
    GossipEvents = 0,
};

struct TNodeInfo {
    ui32 IncarnationNumber{0};
    ui32 UpdatedAtEpoch{0};
    ENodeState State{ENodeState::Unknown};
    bool IsResurgent{false};
};

/**
 * "fqdn:port"
 */
using TNodeEndpoint = TString;
using TClusterMembershipState = THashMap<TNodeEndpoint, TNodeInfo>;

class TGossipEvents: private TEventSlot<EEventSpace::ClusterMembership, GossipEvents> {
    enum {
        Ping = SpaceBegin,
        Ack,
        Timeout,
        Subscribe,
        ClusterStateResponse,
        AddNode,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

public:
    struct TPing: public ::NActors::TEventLocal<TPing, Ping> {
        TString Address;
        TAtomicSharedPtr<TGossips> Gossips;

        explicit TPing(TString address, decltype(Gossips)&& gossips)
            : Address{std::move(address)}
            , Gossips{std::move(gossips)} {
        }
    };

    struct TAck: public ::NActors::TEventLocal<TAck, Ack> {
        struct TAckResponse {
            TString Address;
            ui32 IncarnationNumber;
            bool Success;
            TAtomicSharedPtr<TGossips> Gossips;
        };

        TErrorOr <TAckResponse, TGenericError> Ack;

        explicit TAck(TErrorOr <TAckResponse, TGenericError> ack)
            : Ack{std::move(ack)}
        {
        }
    };

    struct TSubscribe: public ::NActors::TEventLocal<TSubscribe, Subscribe> {
        NActors::TActorId ActorId;

        explicit TSubscribe(NActors::TActorId actorId)
            : ActorId{actorId}
        {}
    };

    struct TClusterStateResponse:
            public ::NActors::TEventLocal<TClusterStateResponse, ClusterStateResponse>
    {
        std::shared_ptr<const TClusterMembershipState> ClusterState;

        explicit TClusterStateResponse(decltype(ClusterState) clusterState)
            : ClusterState{std::move(clusterState)}
        {}
    };

    struct TAddNode: public ::NActors::TEventLocal<TAddNode, AddNode> {
        TString Address;

        explicit TAddNode(TString address)
            : Address{std::move(address)}
        {
        }
    };
};

} // namespace NSolomon::NClusterMembership {
