#pragma once

#include <solomon/libs/cpp/cluster_membership/common.h>
#include <solomon/libs/cpp/grpc/client/client.h>

#include <library/cpp/monlib/metrics/metric_registry.h>
#include <library/cpp/threading/future/future.h>

namespace NSolomon::NClusterMembership {

struct TAckResponse {
    TString Address;
    ui32 IncarnationNumber{0};
    bool Success{false};
    TAtomicSharedPtr<TGossips> Gossips;
};

using TAckResponseOrError = TErrorOr<TAckResponse, ::NGrpc::TGrpcStatus>;
using TAckResponseOrErrorPtr = std::unique_ptr<TAckResponseOrError>;
using TAsyncAckResponse = NThreading::TFuture<TAckResponseOrErrorPtr>;

class IClusterMembershipSingleHostClient {
public:
    virtual ~IClusterMembershipSingleHostClient() = default;

    virtual TAsyncAckResponse Ping(
            TString address,
            TAtomicSharedPtr<TGossips> gossips) noexcept = 0;

    /// Stop the client. This call blocks until all requests are done if wait is set to true
    virtual void Stop(bool wait) = 0;
};

using IClusterMembershipSingleHostClientPtr = std::shared_ptr<IClusterMembershipSingleHostClient>;
using IClusterMembershipClientPtr = std::shared_ptr<IClusterRpc<IClusterMembershipSingleHostClient>>;

IClusterMembershipClientPtr CreateClusterMembershipGrpcClient(
        const yandex::solomon::config::rpc::TGrpcClientConfig& conf,
        NMonitoring::TMetricRegistry& registry,
        TString clientId = {});

} // namespace NSolomon::NClusterMembership
