#include "agent_config.h"

namespace NSolomon::NDb::NModel {
    bool operator==(const TAgentConfig& lhs, const TAgentConfig& rhs) {
        return
            lhs.Provider == rhs.Provider &&
            lhs.Hostname == rhs.Hostname &&
            lhs.DataPort == rhs.DataPort &&
            lhs.ManagementPort == rhs.ManagementPort &&
            lhs.Version == rhs.Version &&
            lhs.LastSeen == rhs.LastSeen &&
            lhs.PullInterval == rhs.PullInterval;
    }

    IOutputStream& operator<<(IOutputStream& os, const TAgentConfig& conf) {
        os << "Provider: " << conf.Provider << '\n'
            << "Hostname: " << conf.Hostname << '\n'
            << "Data port: " << conf.DataPort << '\n'
            << "Management port: " << conf.ManagementPort << '\n'
            << "LastSeen: " << conf.LastSeen << '\n'
            << "Pull interval: " << conf.PullInterval
            << "Version: " << conf.Version;

        return os;
    }
} // namespace NSolomon::NDb::NModel
