#pragma once

#include <util/generic/string.h>
#include <util/datetime/base.h>

#include <util/digest/multi.h>
#include <util/ysaveload.h>

namespace NSolomon::NDb::NModel {
    class TAgentConfig {
    public:
        TString Provider;
        TString Hostname;
        ui16 DataPort{0};
        ui16 ManagementPort{0};
        TString Version;
        TInstant LastSeen;
        TString Description;
        TDuration PullInterval;

        Y_SAVELOAD_DEFINE(Provider, Hostname, DataPort, ManagementPort, Version, LastSeen, Description, PullInterval);
    };

    bool operator==(const TAgentConfig& lhs, const TAgentConfig& rhs);
    IOutputStream& operator<<(IOutputStream& os, const TAgentConfig& conf);
} // namespace NSolomon::NDb::NModel

template<>
struct THash<NSolomon::NDb::NModel::TAgentConfig> {
    size_t operator()(const NSolomon::NDb::NModel::TAgentConfig& agent) {
        return MultiHash(
            THash<TString>{}(agent.Provider),
            THash<TString>{}(agent.Hostname),
            THash<ui16>{}(agent.DataPort)
        );
    }
};
