#pragma once

#include <library/cpp/json/writer/json.h>
#include <library/cpp/json/writer/json_value.h>

#include <util/ysaveload.h>

#include <vector>
#include <optional>

namespace NSolomon::NDb::NModel {

enum class EAggregationFunction {
    SUM,
    LAST,
};

struct TAggregationRule {
    std::vector<TString> Conditions;
    std::vector<TString> Targets;
    EAggregationFunction Function{EAggregationFunction::SUM};

    Y_SAVELOAD_DEFINE(Conditions, Targets, Function);

    static std::optional<TAggregationRule> FromJsonStr(TStringBuf data);
    static TAggregationRule FromJsonVal(const NJson::TJsonValue& json);

    TString ToJsonStr() const;
    void ToJsonVal(NJsonWriter::TBuf& json) const;

    bool operator==(const TAggregationRule&) const = default;
};

IOutputStream& operator<<(IOutputStream& os, const TAggregationRule& rule);
std::ostream& operator<<(std::ostream& os, const TAggregationRule& rule);

struct TAggregationSettings {
    std::vector<TAggregationRule> Rules;
    bool Enabled{false};
    bool MemOnly{false};

    Y_SAVELOAD_DEFINE(Rules, Enabled, MemOnly);

    static std::optional<TAggregationSettings> FromJsonStr(TStringBuf data);
    static TAggregationSettings FromJsonVal(const NJson::TJsonValue& json);

    TString ToJsonStr() const;
    void ToJsonVal(NJsonWriter::TBuf& json) const;

    bool operator==(const TAggregationSettings&) const = default;
};

IOutputStream& operator<<(IOutputStream& os, const TAggregationSettings& settings);
std::ostream& operator<<(std::ostream& os, const TAggregationSettings& settings);

} // namespace NSolomon::NDb::NModel
