#include "cluster_config.h"

#include <util/stream/output.h>

namespace NSolomon::NDb::NModel {

IOutputStream& operator<<(IOutputStream& os, const TClusterConfig& conf) {
    os << "Id: " << conf.Id << "\n"
     << "Name: " << conf.Name << "\n"
     << "Description: " << conf.Description << "\n"
     << "ProjectId: " << conf.ProjectId << "\n"
     << "FolderId: " << conf.FolderId << "\n"
     << "Hosts: " << conf.Hosts << "\n"
     << "HostUrls: " << conf.HostUrls << "\n"
     << "ConductorGroups: " << conf.ConductorGroups << "\n"
     << "ConductorTags: " << conf.ConductorTags << "\n"
     << "NannyGroups: " << conf.NannyGroups << "\n"
     << "QloudGroups: " << conf.QloudGroups << "\n"
     << "Networks: " << conf.Networks << "\n"
     << "YpClusters: " << conf.YpClusters << "\n"
     << "InstanceGroups: " << conf.InstanceGroups << "\n"
     << "CloudDns: " << conf.CloudDns << "\n"
     << "ShardSettings: " << conf.ShardSettings << "\n"
     << "Labels: " << conf.Labels << "\n"
     << "CreatedAt: " << conf.CreatedAt << "\n"
     << "UpdatedAt: " << conf.UpdatedAt << "\n"
     << "CreatedBy: " << conf.CreatedBy << "\n"
     << "UpdatedBy: " << conf.UpdatedBy << "\n"
     << "Version: " << conf.Version;
     return os;
}

bool AnyHostGroupChanged(const TClusterConfig& lhs, const TClusterConfig& rhs) {
    return !(lhs.Hosts == rhs.Hosts
        && lhs.HostUrls == rhs.HostUrls
        && lhs.ConductorGroups == rhs.ConductorGroups
        && lhs.ConductorTags == rhs.ConductorTags
        && lhs.NannyGroups == rhs.NannyGroups
        && lhs.QloudGroups == rhs.QloudGroups
        && lhs.Networks == rhs.Networks
        && lhs.YpClusters == rhs.YpClusters
        && lhs.InstanceGroups == rhs.InstanceGroups
        && lhs.CloudDns == rhs.CloudDns);
}

} // namespace NSolomon::NDb::NModel
