#pragma once

#include "shard_settings.h"

#include <util/generic/string.h>
#include <util/datetime/base.h>
#include <util/ysaveload.h>

namespace NSolomon::NDb::NModel {

class TClusterConfig {
public:
     TString Id;
     TString Name;
     TString Description;
     TString ProjectId;
     TString FolderId;
     TString Hosts;
     TString HostUrls;
     TString ConductorGroups;
     TString ConductorTags;
     TString NannyGroups;
     TString QloudGroups;
     TString Networks;
     TString YpClusters;
     TString InstanceGroups;
     TString CloudDns;
     TShardSettings ShardSettings;
     TString Labels;
     TInstant CreatedAt;
     TInstant UpdatedAt;
     TString CreatedBy;
     TString UpdatedBy;
     ui32 Version {0};

    Y_SAVELOAD_DEFINE(
            Id,
            Name,
            Description,
            ProjectId,
            FolderId,
            Hosts,
            HostUrls,
            ConductorGroups,
            ConductorTags,
            NannyGroups,
            QloudGroups,
            Networks,
            YpClusters,
            InstanceGroups,
            CloudDns,
            ShardSettings,
            Labels,
            CreatedAt,
            UpdatedAt,
            CreatedBy,
            UpdatedBy,
            Version);
};

inline bool operator==(const TClusterConfig& lhs, const TClusterConfig& rhs) {
    return lhs.Id == rhs.Id &&
        lhs.Name == rhs.Name &&
        lhs.Description == rhs.Description &&
        lhs.ProjectId == rhs.ProjectId &&
        lhs.FolderId == rhs.FolderId &&
        lhs.Hosts == rhs.Hosts &&
        lhs.HostUrls == rhs.HostUrls &&
        lhs.ConductorTags == rhs.ConductorTags &&
        lhs.ConductorGroups == rhs.ConductorGroups &&
        lhs.NannyGroups == rhs.NannyGroups &&
        lhs.QloudGroups == rhs.QloudGroups &&
        lhs.Networks == rhs.Networks &&
        lhs.YpClusters == rhs.YpClusters &&
        lhs.InstanceGroups == rhs.InstanceGroups &&
        lhs.CloudDns == rhs.CloudDns &&
        lhs.ShardSettings == rhs.ShardSettings &&
        lhs.Labels == rhs.Labels &&
        lhs.CreatedAt == rhs.CreatedAt &&
        lhs.UpdatedAt == rhs.UpdatedAt &&
        lhs.CreatedBy == rhs.CreatedBy &&
        lhs.UpdatedBy == rhs.UpdatedBy &&
        lhs.Version == rhs.Version;
}

bool AnyHostGroupChanged(const TClusterConfig& lhs, const TClusterConfig& rhs);

IOutputStream& operator<<(IOutputStream& os, const TClusterConfig& conf);

} // namespace NSolomon::NDb::NModel
