#pragma once

#include <library/cpp/json/json_reader.h>

namespace NSolomon::NDb::NModel {

template <typename T>
std::optional<T> FromJsonStr(TStringBuf data) {
    NJson::TJsonReaderConfig readerConfig;
    readerConfig.DontValidateUtf8 = true;

    NJson::TJsonValue jsonValue;
    if (NJson::ReadJsonTree(data, &readerConfig, &jsonValue, false)) {
        return T::FromJsonVal(jsonValue);
    }
    return std::nullopt;
}

template <typename T>
TString ToJsonStr(const T& value) {
    NJsonWriter::TBuf json(NJsonWriter::HEM_RELAXED);
    value.ToJsonVal(json);
    return json.Str();
}

} // namespace NSolomon::NDb::NModel
