#include "project_config.h"

namespace NSolomon::NDb::NModel {

bool operator==(const TProjectConfig& lhs, const TProjectConfig& rhs) {
    return
        lhs.Id == rhs.Id &&
        lhs.Name == rhs.Name &&
        lhs.Description == rhs.Description &&
        lhs.Owner == rhs.Owner &&
        lhs.AbcService == rhs.AbcService &&
        lhs.CreatedAt == rhs.CreatedAt &&
        lhs.CreatedBy == rhs.CreatedBy &&
        lhs.DeleteAcl == rhs.DeleteAcl &&
        lhs.UpdatedAt == rhs.UpdatedAt &&
        lhs.UpdatedBy == rhs.UpdatedBy &&
        lhs.ReadAcl == rhs.ReadAcl &&
        lhs.WriteAcl == rhs.WriteAcl &&
        lhs.UpdateAcl == rhs.UpdateAcl &&
        lhs.Version == rhs.Version &&
        lhs.OnlyAuthPush == rhs.OnlyAuthPush &&
        lhs.OnlyAuthRead == rhs.OnlyAuthRead &&
        lhs.OnlyMetricNameShards == rhs.OnlyMetricNameShards &&
        lhs.OnlyNewFormatWrites == rhs.OnlyNewFormatWrites &&
        lhs.OnlyNewFormatReads == rhs.OnlyNewFormatReads &&
        lhs.MetricNameLabel == rhs.MetricNameLabel &&
        lhs.Labels == rhs.Labels;
}

IOutputStream& operator<<(IOutputStream& os, const TProjectConfig& conf) {
    os << "Id: " << conf.Id << '\n'
        << "Name: " << conf.Name << '\n'
        << "Description: " << conf.Description << '\n'
        << "Owner: " << conf.Owner << '\n'
        << "AbcService: " << conf.AbcService << '\n'
        << "CreatedAt: " << conf.CreatedAt << '\n'
        << "CreatedBy: " << conf.CreatedBy << '\n'
        << "DeleteAcl: " << conf.DeleteAcl << '\n'
        << "UpdatedAt: " << conf.UpdatedAt << '\n'
        << "UpdatedBy: " << conf.UpdatedBy << '\n'
        << "ReadAcl: " << conf.ReadAcl << '\n'
        << "WriteAcl: " << conf.WriteAcl << '\n'
        << "UpdateAcl: " << conf.UpdateAcl << '\n'
        << "Version: " << conf.Version << '\n'
        << "OnlyAuthPush: " << conf.OnlyAuthPush << '\n'
        << "OnlyAuthRead: " << conf.OnlyAuthRead << '\n'
        << "OnlyMetricNameShards: " << conf.OnlyMetricNameShards << '\n'
        << "OnlyNewFormatWrites: " << conf.OnlyNewFormatWrites << '\n'
        << "OnlyNewFormatReads: " << conf.OnlyNewFormatReads << '\n'
        << "MetricNameLabel: " << conf.MetricNameLabel << '\n'
        << "Labels: " << conf.Labels << '\n';

    return os;
}

} // namespace NSolomon::NDb::NModel
