#pragma once

#include <util/datetime/base.h>
#include <util/ysaveload.h>

namespace NSolomon::NDb::NModel {

class TProjectConfig {
public:
    TString Id;
    TString Name;
    TString Description;
    TString Owner;
    TString AbcService;
    TInstant CreatedAt;
    TString CreatedBy;
    TInstant UpdatedAt;
    TString UpdatedBy;
    TString ActivateAcl;
    TString DeleteAcl;
    TString UpdateAcl;
    TString ReadAcl;
    TString WriteAcl;
    ui32 Version{0};
    bool OnlyAuthPush{false};
    bool OnlyAuthRead{false};
    bool OnlyMetricNameShards{false};
    bool OnlyNewFormatWrites{false};
    bool OnlyNewFormatReads{false};
    TString MetricNameLabel;
    TString Labels;

    Y_SAVELOAD_DEFINE(
            Id,
            Name,
            Description,
            Owner,
            AbcService,
            CreatedAt,
            CreatedBy,
            UpdatedAt,
            UpdatedBy,
            ActivateAcl,
            DeleteAcl,
            UpdateAcl,
            ReadAcl,
            WriteAcl,
            Version,
            OnlyAuthPush,
            OnlyAuthRead,
            OnlyMetricNameShards,
            OnlyNewFormatWrites,
            OnlyNewFormatReads,
            MetricNameLabel,
            Labels
    );
};

bool operator==(const TProjectConfig& lhs, const TProjectConfig& rhs);
IOutputStream& operator<<(IOutputStream& os, const TProjectConfig& conf);

} // namespace NSolomon::NDb::NModel
