#pragma once

#include <solomon/libs/cpp/conf_db/model/service_metric_conf.h>

#include <library/cpp/tvmauth/type.h>

#include <util/datetime/base.h>
#include <util/generic/vector.h>
#include <util/ysaveload.h>

namespace NSolomon::NDb::NModel {

class TProviderShardSettings {
public:
    static TProviderShardSettings FromString(const TString& data);

    TString ToString() const;

    TMetricConf MetricConf{};
    ui64 MetricsTtlDays{0};
    TDuration Grid;
    TDuration Interval;

    Y_SAVELOAD_DEFINE(MetricConf, MetricsTtlDays, Grid, Interval);
};

class TReferenceConf {
public:
    static TReferenceConf FromJson(const NJson::TJsonValue& jsonValue);
    static TVector<TReferenceConf> FromStringArray(const TString& data);
    static TString ToStringArray(const TVector<TReferenceConf>& data);

    void ToJson(NJsonWriter::TBuf&) const;
    TString ToString() const;

public:
    TString Label;
    TVector<TString> Services = TVector<TString>();
    TVector<TString> Types = TVector<TString>();
    bool CrossFolder = false;

    Y_SAVELOAD_DEFINE(Label, Services, Types, CrossFolder);
};

class TProviderConfig {
public:
    TString Id;
    TString Description;
    TProviderShardSettings ShardSettings;
    TVector<TReferenceConf> References = TVector<TReferenceConf>();
    TString AbcService;
    TString CloudId;
    TString TvmDestId;
    TVector<TString> IamServiceAccountIds;
    TVector<NTvmAuth::TTvmId> TvmServiceIds;
    TInstant CreatedAt;
    TInstant UpdatedAt;
    TString CreatedBy;
    TString UpdatedBy;
    ui32 Version{0};

    Y_SAVELOAD_DEFINE(
            Id,
            Description,
            ShardSettings,
            References,
            AbcService,
            CloudId,
            TvmDestId,
            IamServiceAccountIds,
            TvmServiceIds,
            CreatedAt,
            UpdatedAt,
            CreatedBy,
            UpdatedBy,
            Version
    );
};

bool operator==(const TProviderShardSettings& lhs, const TProviderShardSettings& rhs);
bool operator==(const TReferenceConf& lhs, const TReferenceConf& rhs);
bool operator==(const TProviderConfig& lhs, const TProviderConfig& rhs);
IOutputStream& operator<<(IOutputStream& os, const TReferenceConf& conf);
IOutputStream& operator<<(IOutputStream& os, const TProviderConfig& conf);

} // namespace NSolomon::NDb::NModel
