#pragma once

#include <library/cpp/json/writer/json.h>
#include <library/cpp/json/writer/json_value.h>

#include <util/stream/output.h>
#include <util/ysaveload.h>

#include <optional>

namespace NSolomon::NDb::NModel {

enum class EPullProtocol {
    UNKNOWN,
    HTTP,
    HTTPS,
};

enum class EHostLabelPolicy {
    UNKNOWN,
    SHORT_HOSTNAME,
    FULL_HOSTNAME,
    NO_HOSTNAME,
};

struct TPullSettings {
    ui16 Port{0};
    TString Path;
    bool AddTsArgs{false};
    EPullProtocol Protocol{EPullProtocol::UNKNOWN};
    ui32 TvmDestId{0};
    EHostLabelPolicy HostLabelPolicy{EHostLabelPolicy::UNKNOWN};

    Y_SAVELOAD_DEFINE(Port, Path, AddTsArgs, Protocol, TvmDestId, HostLabelPolicy);

    static std::optional<TPullSettings> FromJsonStr(TStringBuf data);
    static TPullSettings FromJsonVal(const NJson::TJsonValue& json);

    TString ToJsonStr() const;
    void ToJsonVal(NJsonWriter::TBuf& json) const;

    bool operator==(const TPullSettings&) const = default;
};

IOutputStream& operator<<(IOutputStream& os, const TPullSettings& settings);
std::ostream& operator<<(std::ostream& os, const TPullSettings& settings);

} // namespace NSolomon::NDb::NModel
