#include "service_config.h"

namespace NSolomon::NDb::NModel {

bool operator==(const TServiceConfig& lhs, const TServiceConfig& rhs) {
    return lhs.Id == rhs.Id &&
        lhs.Version == rhs.Version &&
        lhs.CreatedAt == rhs.CreatedAt &&
        lhs.CreatedBy == rhs.CreatedBy &&
        lhs.Interval == rhs.Interval &&
        lhs.GridSec == rhs.GridSec &&
        lhs.Name == rhs.Name &&
        lhs.Description == rhs.Description &&
        lhs.ServiceProvider == rhs.ServiceProvider &&
        lhs.ProjectId == rhs.ProjectId &&
        lhs.FolderId == rhs.FolderId &&
        lhs.MetricConf == rhs.MetricConf &&
        lhs.MetricNameLabel == rhs.MetricNameLabel &&
        lhs.ShardSettings == rhs.ShardSettings &&
        lhs.Labels == rhs.Labels &&
        lhs.UpdatedAt == rhs.UpdatedAt &&
        lhs.UpdatedBy == rhs.UpdatedBy;
}

IOutputStream& operator<<(IOutputStream& os, const TServiceConfig& conf) {
    os << "Id: " << conf.Id << "\n"
        << "Version: " << conf.Version << "\n"
        << "CreatedAt: " << conf.CreatedAt << "\n"
        << "CreatedBy: " << conf.CreatedBy << "\n"
        << "Interval: " << conf.Interval << "\n"
        << "GridSec: " << conf.GridSec << "\n"
        << "Name: " << conf.Name << "\n"
        << "Description: " << conf.Description << "\n"
        << "ServiceProvider: " << conf.ServiceProvider << "\n"
        << "ProjectId: " << conf.ProjectId << "\n"
        << "FolderId: " << conf.FolderId << "\n"
        << "MetricConf: " << conf.MetricConf.ToString() << "\n"
        << "MetricNameLabel: " << conf.MetricNameLabel << "\n"
        << "ShardSettings: " << conf.ShardSettings << "\n"
        << "Labels: " << conf.Labels << "\n"
        << "UpdatedAt: " << conf.UpdatedAt << "\n"
        << "UpdatedBy: " << conf.UpdatedBy << "\n";

    return os;
}

} // namespace NSolomon::NDb::NModel
