#pragma once

#include "shard_settings.h"

#include <solomon/libs/cpp/conf_db/model/service_metric_conf.h>

#include <util/generic/vector.h>
#include <util/generic/string.h>
#include <util/datetime/base.h>

namespace NSolomon::NDb::NModel {

class TServiceConfig {
public:
    static constexpr i32 GRID_ABSENT = -1;

public:
    TString Id;
    ui32 Version {0};
    TInstant CreatedAt;
    TString CreatedBy;
    TDuration Interval;
    i32 GridSec{0};
    TString Name;
    TString Description;
    TString ServiceProvider;
    TString ProjectId;
    TString FolderId;
    TMetricConf MetricConf;
    TString MetricNameLabel;
    TShardSettings ShardSettings;
    TString Labels;
    TInstant UpdatedAt;
    TString UpdatedBy;

    Y_SAVELOAD_DEFINE(
            Id,
            Version,
            CreatedAt,
            CreatedBy,
            Interval,
            GridSec,
            Name,
            Description,
            ServiceProvider,
            ProjectId,
            FolderId,
            MetricConf,
            MetricNameLabel,
            ShardSettings,
            Labels,
            UpdatedAt,
            UpdatedBy
    );
};

bool operator==(const TServiceConfig& lhs, const TServiceConfig& rhs);
IOutputStream& operator<<(IOutputStream& os, const TServiceConfig& conf);

} // namespace NSolomon::NFetcher
