#pragma once

#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/ysaveload.h>

namespace NJson {
class TJsonValue;
} // namespace NJson

namespace NJsonWriter {
class TBuf;
} // namespace NJsonWriter

namespace NSolomon::NDb::NModel {

class TMetricConf {
public:
    class TAggrRuleItem {
    public:
        TVector<TString> Cond;
        TVector<TString> Target;

        Y_SAVELOAD_DEFINE(Cond, Target);
    };

    static TMetricConf FromJsonValue(const NJson::TJsonValue& jsonValue);
    static TMetricConf FromString(const TString& data);

    void AddToJsonOutput(NJsonWriter::TBuf& jsonOutput) const;
    TString ToString() const;

    TVector<TAggrRuleItem> AggrRules;
    bool RawDataMemOnly{false};

    Y_SAVELOAD_DEFINE(AggrRules, RawDataMemOnly);
};

bool operator==(const TMetricConf::TAggrRuleItem& lhs, const TMetricConf::TAggrRuleItem& rhs);
bool operator==(const TMetricConf& lhs, const TMetricConf& rhs);

} // namespace NSolomon::NDb::NModel
