#include "shard_config.h"

namespace NSolomon {
namespace NDb {
namespace NModel {

bool operator==(const TShardConfig& lhs, const TShardConfig& rhs) {
  return lhs.Id == rhs.Id &&
    lhs.NumId == rhs.NumId &&
    lhs.ClusterId == rhs.ClusterId &&
    lhs.ClusterName == rhs.ClusterName &&
    lhs.CreatedAt == rhs.CreatedAt &&
    lhs.CreatedBy == rhs.CreatedBy &&
    lhs.MaxFileMetrics == rhs.MaxFileMetrics &&
    lhs.MaxMemMetrics == rhs.MaxMemMetrics &&
    lhs.MaxResponseSizeBytes == rhs.MaxResponseSizeBytes &&
    lhs.MaxMetricsPerUrl == rhs.MaxMetricsPerUrl &&
    lhs.NumPartitions == rhs.NumPartitions &&
    lhs.ProjectId == rhs.ProjectId &&
    lhs.FolderId == rhs.FolderId &&
    lhs.Description == rhs.Description &&
    lhs.ShardSettings == rhs.ShardSettings &&
    lhs.Labels == rhs.Labels &&
    lhs.DecimPolicy == rhs.DecimPolicy &&
    lhs.ValidationMode == rhs.ValidationMode &&
    lhs.MetricNameLabel == rhs.MetricNameLabel &&
    lhs.ServiceId == rhs.ServiceId &&
    lhs.ServiceName == rhs.ServiceName &&
    lhs.State == rhs.State &&
    lhs.UpdatedAt == rhs.UpdatedAt;
}

IOutputStream& operator<<(IOutputStream& os, const TShardConfig& conf) {
    os << "Id: " << conf.Id << "\n"
        << "NumId: " << conf.NumId << "\n"
        << "ClusterId: " << conf.ClusterId << "\n"
        << "ClusterName: " << conf.ClusterName << "\n"
        << "CreatedAt: " << conf.CreatedAt << "\n"
        << "CreatedBy: " << conf.CreatedBy << "\n";

    os << "\n"
        << "MaxFileMetrics: " << conf.MaxFileMetrics << "\n"
        << "MaxMemMetrics: " << conf.MaxMemMetrics << "\n"
        << "MaxResponseSizeBytes: " << conf.MaxResponseSizeBytes << "\n"
        << "MaxMetricsPerUrl: " << conf.MaxMetricsPerUrl << "\n"
        << "NumPartitions: " << conf.NumPartitions << "\n"
        << "ProjectId: " << conf.ProjectId << "\n"
        << "FolderId: " << conf.FolderId << "\n"
        << "Description: " << conf.Description << "\n"
        << "ShardSettings: " << conf.ShardSettings << "\n"
        << "Labels: " << conf.Labels << "\n"
        << "DecimPolicy: " << conf.DecimPolicy << "\n"
        << "ValidationMode: " << conf.ValidationMode << "\n"
        << "MetricNameLabel: " << conf.MetricNameLabel << "\n"
        << "ServiceId: " << conf.ServiceId << "\n"
        << "ServiceName: " << conf.ServiceName << "\n"
        << "State: " << conf.State << "\n"
        << "UpdatedAt: " << conf.UpdatedAt << "\n";

    return os;
}

} // namespace NModel
} // namespace NDb
} // namespace NSolomon
