#pragma once

#include "shard_state.h"
#include "shard_settings.h"

#include <util/datetime/base.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NSolomon::NDb::NModel {

class TShardConfig {
public:
    TString Id;
    ui32 NumId {0};
    TString ClusterId;
    TString ClusterName;
    TInstant CreatedAt;
    TString CreatedBy;
    ui32 MaxFileMetrics {0};
    ui32 MaxMemMetrics {0};
    ui32 MaxResponseSizeBytes {0};
    ui32 MaxMetricsPerUrl {0};
    ui32 NumPartitions {1};
    TString ValidationMode;
    TString ProjectId;
    TString FolderId;
    TString Description;
    TShardSettings ShardSettings;
    TString Labels;
    TString DecimPolicy;
    TString MetricNameLabel;
    TString ServiceId;
    TString ServiceName;
    EShardState State;
    TInstant UpdatedAt;
    TString UpdatedBy;
    ui32 Version {0};

    Y_SAVELOAD_DEFINE(
            Id,
            NumId,
            ClusterId,
            ClusterName,
            CreatedAt,
            CreatedBy,
            MaxFileMetrics,
            MaxMemMetrics,
            MaxResponseSizeBytes,
            MaxMetricsPerUrl,
            NumPartitions,
            ValidationMode,
            ProjectId,
            FolderId,
            Description,
            ShardSettings,
            Labels,
            DecimPolicy,
            MetricNameLabel,
            ServiceId,
            ServiceName,
            State,
            UpdatedAt,
            UpdatedBy,
            Version
    );

};

bool operator==(const TShardConfig& lhs, const TShardConfig& rhs);
IOutputStream& operator<<(IOutputStream& os, const TShardConfig& conf);

inline bool IsWriteable(const TShardConfig& shard) {
    return shard.State != EShardState::Inactive && shard.State != EShardState::ReadOnly;
}

} // namespace NSolomon::NDb::NModel
